<?php if (!defined('IN_PHPOESOC')) {
  exit('Request Error!');
}
use PHPMailer\PHPMailer\PHPMailer;
/*
 **************************
(C)2016-2021 test.com
update: 2014-5-31 21:57:40
person: Feng
 **************************
 */

/*
 * 函数说明：截取指定长度的字符串
 *         utf-8专用 汉字和大写字母长度算1，其它字符长度算0.5
 *
 * @param  string  $str  原字符串
 * @param  int     $len  截取长度
 * @param  string  $etc  省略字符...
 * @return string        截取后的字符串
 */
if (!function_exists('ReStrLen')) {
  function ReStrLen($str, $len = 10, $etc = '...')
  {
    $restr = '';
    $i     = 0;
    $n     = 0.0;

    //字符串的字节数
    $strlen = strlen($str);
    while (($n < $len) and ($i < $strlen)) {
      $temp_str = substr($str, $i, 1);

      //得到字符串中第$i位字符的ASCII码
      $ascnum = ord($temp_str);

      //如果ASCII位高与252
      if ($ascnum >= 252) {
        //根据UTF-8编码规范，将6个连续的字符计为单个字符
        $restr = $restr . substr($str, $i, 6);
        //实际Byte计为6
        $i = $i + 6;
        //字串长度计1
        $n++;
      } else if ($ascnum >= 248) {
        $restr = $restr . substr($str, $i, 5);
        $i     = $i + 5;
        $n++;
      } else if ($ascnum >= 240) {
        $restr = $restr . substr($str, $i, 4);
        $i     = $i + 4;
        $n++;
      } else if ($ascnum >= 224) {
        $restr = $restr . substr($str, $i, 3);
        $i     = $i + 3;
        $n++;
      } else if ($ascnum >= 192) {
        $restr = $restr . substr($str, $i, 2);
        $i     = $i + 2;
        $n++;
      }

      //如果是大写字母 I除外
      else if ($ascnum >= 65 and $ascnum <= 90 and $ascnum != 73) {
        $restr = $restr . substr($str, $i, 1);
        //实际的Byte数仍计1个
        $i = $i + 1;
        //但考虑整体美观，大写字母计成一个高位字符
        $n++;
      }

      //%,&,@,m,w 字符按1个字符宽
      else if (!(array_search($ascnum, array(37, 38, 64, 109, 119)) === false)) {
        $restr = $restr . substr($str, $i, 1);
        //实际的Byte数仍计1个
        $i = $i + 1;
        //但考虑整体美观，这些字条计成一个高位字符
        $n++;
      }

      //其他情况下，包括小写字母和半角标点符号
      else {
        $restr = $restr . substr($str, $i, 1);
        //实际的Byte数计1个
        $i = $i + 1;
        //其余的小写字母和半角标点等与半个高位字符宽
        $n = $n + 0.5;
      }
    }

    //超过长度时在尾处加上省略号
    if ($i < $strlen) {
      $restr = $restr . $etc;
    }

    return $restr;
  }
}

//获得当前的页面文件的url
if (!function_exists('GetCurUrl')) {
  function GetCurUrl()
  {
    if (!empty($_SERVER['REQUEST_URI'])) {
      $nowurls = explode('?', $_SERVER['REQUEST_URI']);
      $nowurl  = $nowurls[0];
    } else {
      $nowurl = $_SERVER['PHP_SELF'];
    }

    return $nowurl;
  }
}

//获取IP
if (!function_exists('GetIP')) {
  function GetIP()
  {
    static $ip = null;
    if ($ip !== null) {
      return $ip;
    }

    if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
      $arr = explode(',', $_SERVER['HTTP_X_FORWARDED_FOR']);
      $pos = array_search('unknown', $arr);
      if (false !== $pos) {
        unset($arr[$pos]);
      }

      $ip = trim($arr[0]);
    } else if (isset($_SERVER['HTTP_CLIENT_IP'])) {
      $ip = $_SERVER['HTTP_CLIENT_IP'];
    } else if (isset($_SERVER['REMOTE_ADDR'])) {
      $ip = $_SERVER['REMOTE_ADDR'];
    }

    //IP地址合法验证
    $ip = (false !== ip2long($ip)) ? $ip : '0.0.0.0';
    return $ip;
  }
}

//查看数据大小
if (!function_exists('GetRealSize')) {
  function GetRealSize($size)
  {
    $kb = 1024; // Kilobyte
    $mb = 1024 * $kb; // Megabyte
    $gb = 1024 * $mb; // Gigabyte
    $tb = 1024 * $gb; // Terabyte

    if ($size < $kb) {
      return $size . 'B';
    } else if ($size < $mb) {
      return round($size / $kb, 2) . 'KB';
    } else if ($size < $gb) {
      return round($size / $mb, 2) . 'MB';
    } else if ($size < $tb) {
      return round($size / $gb, 2) . 'GB';
    } else {
      return round($size / $tb, 2) . 'TB';
    }

  }
}

//获取文件夹大小
if (!function_exists('GetDirSize')) {
  function GetDirSize($dir)
  {
    $handle = opendir($dir);
    $fsize  = '';

    while (($fname = readdir($handle)) !== false) {
      if ($fname != '.' && $fname != '..') {
        if (is_dir("$dir/$fname")) {
          $fsize += GetDirSize("$dir/$fname");
        } else {
          $fsize += filesize("$dir/$fname");
        }

      }
    }

    closedir($handle);
    if (empty($fsize)) {
      $fsize = 0;
    }

    return $fsize;
  }
}

//返回格林威治标准时间
if (!function_exists('MyDate')) {
  function MyDate($format = 'Y-m-d H:i:s', $timest = 0)
  {
    global $cfg_timezone;

    $addtime = $cfg_timezone * 3600;
    if (empty($format)) {
      $format = 'Y-m-d H:i:s';
    }

    return gmdate($format, $timest + $addtime);
  }
}

//返回格式化(Y-m-d H:i:s)的时间
if (!function_exists('GetDateTime')) {
  function GetDateTime($mktime)
  {
    return MyDate('Y-m-d H:i:s', $mktime);
  }
}

//返回格式化(Y-m-d)的日期
if (!function_exists('GetDateMk')) {
  function GetDateMk($mktime)
  {
    return MyDate('Y-m-d', $mktime);
  }
}

//从普通时间转换为Linux时间截
if (!function_exists('GetMkTime')) {
  function GetMkTime($dtime)
  {
    if (!preg_match("/[^0-9]/", $dtime)) {
      return $dtime;
    }
    $dtime = trim($dtime);
    $dt    = array(1970, 1, 1, 0, 0, 0);
    $dtime = preg_replace("/[\r\n\t]|日|秒/", " ", $dtime);
    $dtime = str_replace("年", "-", $dtime);
    $dtime = str_replace("月", "-", $dtime);
    $dtime = str_replace("时", ":", $dtime);
    $dtime = str_replace("分", ":", $dtime);
    $dtime = trim(preg_replace("/[ ]{1,}/", " ", $dtime));
    $ds    = explode(" ", $dtime);
    $ymd   = explode("-", $ds[0]);
    if (!isset($ymd[1])) {
      $ymd = explode(".", $ds[0]);
    }

    if (isset($ymd[0])) {
      $dt[0] = $ymd[0];
    }

    if (isset($ymd[1])) {
      $dt[1] = $ymd[1];
    }

    if (isset($ymd[2])) {
      $dt[2] = $ymd[2];
    }

    if (strlen($dt[0]) == 2) {
      $dt[0] = '20' . $dt[0];
    }

    if (isset($ds[1])) {
      $hms = explode(":", $ds[1]);
      if (isset($hms[0])) {
        $dt[3] = $hms[0];
      }

      if (isset($hms[1])) {
        $dt[4] = $hms[1];
      }

      if (isset($hms[2])) {
        $dt[5] = $hms[2];
      }

    }
    foreach ($dt as $k => $v) {
      $v = preg_replace("/^0{1,}/", '', trim($v));
      if ($v == '') {
        $dt[$k] = 0;
      }
    }

    $mt = mktime($dt[3], $dt[4], $dt[5], $dt[1], $dt[2], $dt[0]);
    if (!empty($mt)) {
      return $mt;
    } else {
      return time();
    }

  }
}

//创建多级目录
if (!function_exists('MkDirs')) {
  function MkDirs($dir)
  {
    return is_dir($dir) or (MkDirs(dirname($dir)) and mkdir($dir, 0777));
  }
}

//显示信息
if (!function_exists('ShowMsg')) {
  function ShowMsg($msg = '', $gourl = '-1')
  {
    if ($gourl == '-1') {
      echo '<script>alert("' . $msg . '");history.go(-1);</script>';
    } else if ($gourl == '0') {
      echo '<script>alert("' . $msg . '");location.reload();</script>';
    } else {
      echo '<script>alert("' . $msg . '");location.href="' . $gourl . '";</script>';
    }

  }
}

//读取文件内容
if (!function_exists('Readf')) {
  function Readf($file)
  {
    if (file_exists($file) && is_readable($file)) {
      if (function_exists('file_get_contents')) {
        $str = file_get_contents($file);
      } else {
        $str = '';

        $fp = fopen($file, 'r');
        while (!feof($fp)) {
          $str .= fgets($fp, 1024);
        }
        fclose($fp);
      }
      return $str;
    } else {
      return false;
    }
  }
}

//写入文件内容
if (!function_exists('Writef')) {
  function Writef($file, $str, $mode = 'w')
  {
    if (file_exists($file) && is_writable($file)) {
      $fp = fopen($file, $mode);
      flock($fp, 3);
      fwrite($fp, $str);
      fclose($fp);

      return true;
    } else if (!file_exists($file)) {
      $fp = fopen($file, $mode);
      flock($fp, 3);
      fwrite($fp, $str);
      fclose($fp);
    } else {
      return false;
    }
  }
}

//查看url中是否包含http
if (!function_exists('IsHttpUrl')) {
  function IsHttpUrl($url)
  {
    if (!preg_match("/^(http|ftp):/", $url)) {
      $url = 'http://' . $url;
    }

    return $url;
  }
}

//执行时间函数
if (!function_exists('ExecTime')) {
  function ExecTime()
  {
    $time = explode(" ", microtime());
    $usec = (double) $time[0];
    $sec  = (double) $time[1];
    return $sec + $usec;
  }
}

//清除HTML
if (!function_exists('ClearHtml')) {
  function ClearHtml($str)
  {
    $str = strip_tags($str);

    //首先去掉头尾空格
    $str = trim($str);

    //接着去掉两个空格以上的
    $str = preg_replace('/\s(?=\s)/', '', $str);

    //最后将非空格替换为一个空格
    $str = preg_replace('/[\n\r\t]/', ' ', $str);

    return $str;
  }
}

//获取指定长度随机字符串
if (!function_exists('GetRandStr')) {
  function GetRandStr($length = 6)
  {
    //'!@#$%^&*()-_ []{}<>~`+=,.;:/?|';
    $chars      = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    $random_str = '';

    for ($i = 0; $i < $length; $i++) {
      //这里提供两种字符获取方式
      //第一种是使用 substr 截取$chars中的任意一位字符；
      //第二种是取字符数组 $chars 的任意元素
      //$password .= substr($chars, mt_rand(0, strlen($chars) - 1), 1);
      $random_str .= $chars[mt_rand(0, strlen($chars) - 1)];
    }

    return $random_str;
  }
}

/* 参数解释
$string： 明文 或 密文
$operation：DECODE表示解密,其它表示加密
$key： 密匙
$expiry：密文有效期*/
if (!function_exists('AuthCode')) {
  function AuthCode($string, $operation = 'DECODE', $key = '', $expiry = 0)
  {
    // 动态密匙长度，相同的明文会生成不同密文就是依靠动态密匙
    // 加入随机密钥，可以令密文无任何规律，即便是原文和密钥完全相同，加密结果也会每次不同，增大破解难度。
    // 取值越大，密文变动规律越大，密文变化 = 16 的 $ckey_length 次方
    // 当此值为 0 时，则不产生随机密钥
    $ckey_length = 4;
    // 密匙
    $key = md5($key ? $key : $GLOBALS['cfg_auth_key']);
    // 密匙a会参与加解密
    $keya = md5(substr($key, 0, 16));
    // 密匙b会用来做数据完整性验证
    $keyb = md5(substr($key, 16, 16));
    // 密匙c用于变化生成的密文
    $keyc = $ckey_length ? ($operation == 'DECODE' ? substr($string, 0, $ckey_length) : substr(md5(microtime()), -$ckey_length)) : '';
    // 参与运算的密匙
    $cryptkey   = $keya . md5($keya . $keyc);
    $key_length = strlen($cryptkey);
    // 明文，前10位用来保存时间戳，解密时验证数据有效性，10到26位用来保存$keyb(密匙b)，解密时会通过这个密匙验证数据完整性
    // 如果是解码的话，会从第$ckey_length位开始，因为密文前$ckey_length位保存 动态密匙，以保证解密正确
    $string        = $operation == 'DECODE' ? base64_decode(substr($string, $ckey_length)) : sprintf('%010d', $expiry ? $expiry + time() : 0) . substr(md5($string . $keyb), 0, 16) . $string;
    $string_length = strlen($string);
    $result        = '';
    $box           = range(0, 255);
    $rndkey        = array();

    // 产生密匙簿
    for ($i = 0; $i <= 255; $i++) {
      $rndkey[$i] = ord($cryptkey[$i % $key_length]);
    }

    // 用固定的算法，打乱密匙簿，增加随机性，好像很复杂，实际上并不会增加密文的强度
    for ($j = $i = 0; $i < 256; $i++) {
      //$j是三个数相加与256取余
      $j       = ($j + $box[$i] + $rndkey[$i]) % 256;
      $tmp     = $box[$i];
      $box[$i] = $box[$j];
      $box[$j] = $tmp;
    }

    // 核心加解密部分
    for ($a = $j = $i = 0; $i < $string_length; $i++) {
      //在上面基础上再加1 然后和256取余
      $a       = ($a + 1) % 256;
      $j       = ($j + $box[$a]) % 256; //$j加$box[$a]的值 再和256取余
      $tmp     = $box[$a];
      $box[$a] = $box[$j];
      $box[$j] = $tmp;
      // 从密匙簿得出密匙进行异或，再转成字符，加密和解决时($box[($box[$a] + $box[$j]) % 256])的值是不变的。
      $result .= chr(ord($string[$i]) ^ ($box[($box[$a] + $box[$j]) % 256]));
    }

    if ($operation == 'DECODE') {
      // substr($result, 0, 10) == 0 验证数据有效性
      // substr($result, 0, 10) - time() > 0 验证数据有效性
      // substr($result, 10, 16) == substr(md5(substr($result, 26).$keyb), 0, 16) 验证数据完整性
      // 验证数据有效性，请看未加密明文的格式
      if ((substr($result, 0, 10) == 0 || substr($result, 0, 10) - time() > 0) && substr($result, 10, 16) == substr(md5(substr($result, 26) . $keyb), 0, 16)) {
        return substr($result, 26);
      } else {
        return '';
      }
    } else {
      // 把动态密匙保存在密文里，这也是为什么同样的明文，生产不同密文后能解密的原因
      // 因为加密后的密文可能是一些特殊字符，复制过程可能会丢失，所以用base64编码
      return $keyc . str_replace('=', '', base64_encode($result));
    }
  }
}

/*字符串转数组*/
if (!function_exists('String2Array')) {
  function String2Array($data)
  {
    if ($data == '') {
      return array();
    }

    @eval("\$array = $data;");
    return $array;
  }
}

/**
 *判断是否是通过手机访问
 */
if (!function_exists('isMobile')) {
  function IsMobile()
  {

    //如果有HTTP_X_WAP_PROFILE则一定是移动设备
    if (isset($_SERVER['HTTP_X_WAP_PROFILE'])) {
      return true;
    }

    //如果via信息含有wap则一定是移动设备,部分服务商会屏蔽该信息
    if (isset($_SERVER['HTTP_VIA'])) {
      //找不到为flase,否则为true
      return stristr($_SERVER['HTTP_VIA'], "wap") ? true : false;
    }

    //判断手机发送的客户端标志,兼容性有待提高
    if (isset($_SERVER['HTTP_USER_AGENT'])) {

      $clientkeywords = array('nokia', 'sony', 'ericsson', 'mot', 'samsung', 'htc', 'sgh', 'lg', 'sharp', 'sie-', 'philips', 'panasonic', 'alcatel', 'lenovo', 'iphone', 'ipod', 'blackberry', 'meizu', 'android', 'netfront', 'symbian', 'ucweb', 'windowsce', 'palm', 'operamini', 'operamobi', 'openwave', 'nexusone', 'cldc', 'midp', 'wap', 'mobile');

      //从HTTP_USER_AGENT中查找手机浏览器的关键字
      if (preg_match('/(' . implode('|', $clientkeywords) . ')/i', strtolower($_SERVER['HTTP_USER_AGENT']))) {
        return true;
      }
    }

    //协议法，因为有可能不准确，放到最后判断
    if (isset($_SERVER['HTTP_ACCEPT'])) {
      //如果只支持wml并且不支持html那一定是移动设备
      //如果支持wml和html但是wml在html之前则是移动设备
      if ((strpos($_SERVER['HTTP_ACCEPT'], 'vnd.wap.wml') !== false) &&
        (strpos($_SERVER['HTTP_ACCEPT'], 'text/html') === false ||
          (strpos($_SERVER['HTTP_ACCEPT'], 'vnd.wap.wml') < strpos($_SERVER['HTTP_ACCEPT'], 'text/html')))) {
        return true;
      }
    }

    return false;
  }
}

/*
 * 函数说明：碎片数据调用
 *
 * @access  public
 * @param   $id   int  碎片ID
 * @param   $t    int  调用的内容 0为内容 1为标识名称 2为缩略图 3为跳转连接 4组图 5视频
 * @return  string     返回碎片缩略图地址
 */
function GetFragment($id = 0, $t = 0)
{
  global $dosql;

  if ($t == 0) {
    $field = 'content';
  } else if ($t == 1) {
    $field = 'title';
  } else if ($t == 2) {
    $field = 'picurl';
  } else if ($t == 3) {
    $field = 'linkurl';
  } else if ($t == 4) {
    $field = 'picarr';
  } else if ($t == 5) {
    $field = 'videourl';
  } else {
    $field = '*';
  }

  $r = $dosql->GetOne("SELECT `$field` as `f` FROM `#@__fragment` WHERE `id`=$id");
  if (isset($r) && is_array($r)) {
    return $r['f'];
  }
}

//获取任意字段
/**
 * [GetField description]
 * @param [type] $tbname [description]
 * @param [type] $field  [description]
 * @param [type] $id     [description]
 */
function GetField($tbname, $field, $id)
{
  global $dosql;
  $tbname = "#@__" . $tbname;
  $r      = $dosql->GetOne("SELECT `$field` FROM `$tbname` WHERE `id`=$id");
  if (isset($r) && is_array($r)) {
    return $r[$field];
  } else {
    return '数据被删除';
  }
}

function GetFlage($flag)
{
  global $dosql;
  $tbname = "#@__infoflag";
  $r      = $dosql->GetOne("SELECT `flagname` FROM `$tbname` WHERE `flag`='$flag'");
  if (isset($r) && is_array($r)) {
    return $r['flagname'];
  } else {
    return '数据被删除';
  }
}

 

//获取联级任意字段
function GetCascadedataField($datagroup, $datavalue)
{
  global $dosql;

  $r = $dosql->GetOne("SELECT `dataname` FROM `#@__cascadedata` WHERE `datavalue`=$datavalue and `datagroup`='$datagroup' ");
  if (isset($r) && is_array($r)) {
    return $r['dataname'];
  } else {
    return '数据被删除';
  }
}

//返回JSON格式得AJAX数据
function returnAjax($status = 0, $message = '', $data = array(), $url = "", $type = '')
{
  $data = array('status' => $status, 'message' => $message, 'data' => $data, 'redirect' => $url, 'type' => $type);

  exit(json_encode($data));
}

/*前台输入数据处理*/
if (!function_exists('handleData')) {
  function handleData($param = array())
  {
    if ($param == '') {
      return array();
    }

    foreach ($param as $key => &$vo) {
      $vo = htmlspecialchars(trim($vo));
    }
    return $param;
  }
}

/*
 * 函数说明：发送短信验证码
 *
 * @access  public
 * @param   $mobile   int  手机号
 * @return  arr     返回状态
 */
function sendsms($mobile = '')
{
  $num      = rand(100000, 999999);
  $save_num = md5(md5($num));
  date_default_timezone_set('PRC'); //设置时区
  //模板信息发送demo
  $url = "https://api.mix2.zthysms.com/v2/sendSms";

  $username   = "Xiaobi111111";
  $password   = "111111";
  $serverName = '【OESOC】';

  $tKey     = time();
  $password = md5(md5($password) . $tKey);
  $date     = array(
    'username' => $username, //用户名
    'password' => $password, //密码
    'tKey'     => $tKey, //tKey
    'mobile'   => $mobile, //手机号码
    'content'  => $serverName . $num . "是您的本次的验证码。",
  );
  $ret    = httpPost($url, $date);
  $return = json_decode($ret, true);
  // var_dump($return);
  if ($return['code'] == '200') {
    setcookie('sms_' . $mobile, $save_num);
    return array('status' => 1, 'message' => '发送成功');
  } else {
    return array('status' => 0, 'message' => '获取失败' . $return['code']);
  }
}

function httpPost($url, $date)
{
  // 模拟提交数据函数
  $curl = curl_init(); // 启动一个CURL会话
  curl_setopt($curl, CURLOPT_URL, $url); // 要访问的地址
  curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false); // 对认证证书来源的检查
  curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false); // 从证书中检查SSL加密算法是否存在
  curl_setopt($curl, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']); // 模拟用户使用的浏览器
  curl_setopt($curl, CURLOPT_POST, true); // 发送一个常规的Post请求
  curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($date)); // Post提交的数据包
  curl_setopt($curl, CURLOPT_TIMEOUT, 30); // 设置超时限制防止死循环
  curl_setopt($curl, CURLOPT_HEADER, false); // 显示返回的Header区域内容
  curl_setopt($curl, CURLOPT_RETURNTRANSFER, true); // 获取的信息以文件流的形式返回
  curl_setopt($curl, CURLOPT_HEADER, false); //开启header
  curl_setopt($curl, CURLOPT_HTTPHEADER, array(
    'Content-Type: application/json; charset=utf-8',
  )); //类型为json
  $result = curl_exec($curl); // 执行操作
  if (curl_errno($curl)) {
    echo 'Error POST' . curl_error($curl);
  }
  curl_close($curl); // 关键CURL会话
  return $result; // 返回数据
}

/*
 * 函数说明：生成带背景图的二维码
 *
 * @access  public
 * @param   $member   int  用户id
 * @return  str     返回图片地址
 */
function getmineqrcode($member)
{
  // if(file_exists("./uploads/qrcode/vqrcode/".$member.".png")){
  //     return "./uploads/qrcode/vqrcode/".$member.".png";
  // }
  $path_1 = PHPOESOC_ROOT . "/uploads/qrcode/bg.png"; //用于合成的背景图必须png 750*1200

  $path_2 = PHPOESOC_ROOT . '/' . scerweima($member, 'http://reg.php?parentid=' . $member);
  // return $path_2;
  // exit;
  $image_1 = imagecreatefrompng($path_1);
  $image_2 = imagecreatefrompng($path_2);
  $image_3 = imageCreatetruecolor(imagesx($image_1), imagesy($image_1));
  $color   = imagecolorallocate($image_3, 255, 255, 255);
  imagefill($image_3, 0, 0, $color);
  imageColorTransparent($image_3, $color);
  imagecopyresampled($image_3, $image_1, 0, 0, 0, 0, imagesx($image_1), imagesy($image_1), imagesx($image_1), imagesy($image_1));
  imagecopymerge($image_3, $image_2, 250, 400, 0, 0, imagesx($image_2), imagesy($image_2), 90);
  //将画布保存到指定的gif文件
  imagejpeg($image_3, PHPOESOC_ROOT . "/uploads/qrcode/hecheng_code/" . $member . ".png");
  return "uploads/qrcode/hecheng_code/" . $member . ".png";

}

/*
 * 函数说明：生成二维码
 *
 * @access  public
 * @param   $name   str
 * @param   $url   str
 * @return  str     返回图片地址
 */
function scerweima($name = 0, $url = '')
{
  // $filename =  PHPOESOC_UPLOAD.'/qrcode/original_code/'.$name.'.png';
  // if(file_exists($filename)){
  //     return $filename;
  // }
  require_once PHPOESOC_ROOT . '/extend/phpqrcode/phpqrcode.php';
  $value                = $url; //二维码内容
  $errorCorrectionLevel = 'L'; //容错级别
  $matrixPointSize      = 9; //生成图片大小
  $return_url           = 'uploads/qrcode/original_code/' . $name . '.png';
  $filename             = PHPOESOC_ROOT . '/' . $return_url;
  QRcode::png($value, $filename, $errorCorrectionLevel, $matrixPointSize, 2);
  return $return_url;
}

/*
 * 函数说明：发送邮件
 *
 * @access  public
 * @param   $name   str
 * @param   $url   str
 * @return  str     返回图片地址
 */
// 参数说明(发送到的邮箱地址, 邮件主题, 邮件内容, 接受方的的姓名)
//邮发方法的定义
function sendemail($sendto_email, $subject = null, $body = null, $sendto_name = null)
{
  // php 版本有要求高版本
  // echo !extension_loaded('openssl')?'Not Available':'Available';
  require_once PHPOESOC_ROOT . '/extend/PHPMailer/Exception.php';
  require_once PHPOESOC_ROOT . '/extend/PHPMailer/PHPMailer.php';
  require_once PHPOESOC_ROOT . '/extend/PHPMailer/SMTP.php';

  //新建一个邮件发送类对象
  $mail            = new PHPMailer();
  $mail->SMTPDebug = 0; // 调试模式输出
  // send via SMTP
  $mail->IsSMTP(); // 启用SMTP
  // SMTP 邮件服务器地址，这里需要替换为发送邮件的邮箱所在的邮件服务器地址
  $mail->Host = "smtp.qq.com";
  //邮件服务器验证开
  $mail->SMTPAuth = true;
  // SMTP服务器上此邮箱的用户名，有的只需要@前面的部分，有的需要全名。请替换为正确的邮箱用户名
  $mail->Username = "136267972@qq.com";
  // SMTP服务器上该邮箱的密码，请替换为正确的密码 客户端授权密码”而不是邮箱的登录密码
  $mail->Password = "uddfmdftovrsbhgi";
  // SMTP服务器上发送此邮件的邮箱，请替换为正确的邮箱 ,与$mail->Username 的值是对应的。
  $mail->From = "136267972@qq.com";
  // 真实发件人的姓名等信息，这里根据需要填写
  $mail->FromName = "[" . date('Y-m-d H:i:s', time()) . "]需求系统邮件";
  // 这里指定字符集！
  $mail->CharSet = "utf-8";
  // $mail->Encoding = base64;

  $mail->SMTPSecure = 'ssl'; // 允许 TLS 或者ssl协议
  $mail->Port       = 465; // 服务器端口 25 或者465 具体要看邮箱服务器支持
  $mail->setFrom('136267972@qq.com', '136267972@qq'); //发件人
  // 收件人邮箱和姓名
  $mail->AddAddress($sendto_email, $sendto_name); // 收件人
  //$mail->addAddress('ellen@example.com');  // 可添加多个收件人
  //这一项根据需要而设
  // $mail->AddReplyTo ( 'xxxx@qq.com', "admin" );//回复的时候回复给哪个邮箱 建议和发件人一致
  //$mail->addCC('cc@example.com');                    //抄送
  //$mail->addBCC('bcc@example.com');                    //密送
  // set word wrap
  //$mail->WordWrap = 50;
  // 附件处理
  //$mail->AddAttachment("/var/tmp/file.tar.gz"); // 添加附件
  //$mail->AddAttachment("/tmp/image.jpg", "new.jpg");// 发送附件并且重命名
  // 发送 HTML邮件
  $mail->IsHTML(false); // 是否以HTML文档格式发送  发送后客户端可直接显示对应HTML内容

  $mail->Subject = $subject; //邮件主题

  $mail->Body    = $body; // 邮件内容
  $mail->AltBody = "text/html"; //如果邮件客户端不支持HTML则显示此内容
  $result        = $mail->Send();
  if ($result) {
    return array('status' => 1, 'message' => '发送成功');
  } else {
    return array('status' => 0, 'message' => '发送失败' . $mail->ErrorInfo);
  }
}

function inBrowse()
{
  global $dosql;

  $ip       = gethostbyname($_SERVER['REMOTE_ADDR']);
  $posttime = time();
  $date     = MyDate('Y-m-d', $posttime);

  $sql = "INSERT INTO `#@__browse` (ip, posttime) VALUES ('$ip','$posttime')";
  $dosql->ExecNoneQuery($sql);

  $row = $dosql->GetOne("SELECT * FROM `#@__browse_count` WHERE `date`= '$date' ");
  if (empty($row)) {
    $dosql->ExecNoneQuery("INSERT INTO `#@__browse_count` (views,date) VALUES (1,'$date')");
  } else {
    $dosql->ExecNoneQuery("UPDATE `#@__browse_count` SET views=views+1 WHERE `date`= '$date'");
  }

}

/**
 * [comPost 公共提交处理方法添加/修改]
 * @param  [type] $tbname [表名]
 * @param  array  $param  [处理的数据]
 * @return [type]         [bool]
 */
function comPost($tbname, $param = array())
{
  global $dosql;
  // 剔除干扰数据
  if (isset($param['action'])) {
    unset($param['action']);
  }
  if (isset($param['file'])) {
    unset($param['file']);
  }

  // 数据处理
  if (isset($param['picarr'])) {
    if (empty($param['picarr'])) {
      $param['picarr'] = '';
    } else {
      $param['picarr'] = implode(',', array_filter($param['picarr']));
    }

  }
  // flag
  if (isset($param['flag'])) {
    $param['flag'] = implode(',', $param['flag']);
  }
  if (isset($param['posttime'])) {
    $param['posttime'] = GetMkTime($param['posttime']);
  }

  if (isset($param['regtime'])) {
    $param['regtime'] = GetMkTime($param['regtime']);
  }

  if (isset($param['logintime'])) {
    $param['logintime'] = GetMkTime($param['logintime']);
  }

  //富文本编辑框
  if(isset($param['content'])){
    $param['content'] = htmlspecialchars($param['content']);
  }
  

  // exit;
  if (isset($param['id'])) {
    $id = $param['id'];
    unset($param['id']);
    $fieldname = '';
    $i         = 0;
    foreach ($param as $key => $vo) {
      $i++;
      if ($i == 1) {
        $fieldname .= "`$key`='$vo' ";
      } else {
        $fieldname .= ", `$key`='$vo' ";
      }
    }

    $sql = "UPDATE `#@__$tbname` SET " . $fieldname . "  WHERE `id`= $id";
  } else {
    $i          = 0;
    $fieldname  = '';
    $fieldvalue = '';
    foreach ($param as $key => $vo) {
      $i++;
      if ($i == 1) {
        $fieldname .= $key;
        $fieldvalue .= "'" . $vo . "'";
      } else {
        $fieldname .= ',' . $key;
        $fieldvalue .= ",'" . $vo . "'";
      }

    }
    $sql = "INSERT INTO `#@__$tbname` (" . $fieldname . ") VALUES (" . $fieldvalue . ")";
  }

  if ($dosql->ExecNoneQuery($sql)) {
   
    return true;
  } else {
    return false;
  }
}

if (!function_exists('singleUpdate')) {
  /**
   * [单个数据修改]
   * @param  [type] $tbname [表名]
   * @param  array  $data   [需要修改的数据组]
   * @param  [type] $id     [id]
   * @return [type]         [description]
   */
  function singleUpdate($tbname, $data = array(), $id)
  {
    global $dosql;
    $data['id'] = $id;
    $res        = comPost($tbname, $data);
    returnAjax($res, $res ? "更新成功" : '更新失败');
  }
}

if (!function_exists('singleDelete')) {
  /**
   * [单个数据删除]
   * @param  [type] $tbname [表名]
   * @param  array  $delfile [需要删除的文件对应字段名]
   * @param  [type] $id     [id]
   * @return [type]         [description]
   */
  function singleDelete($tbname, $id, $delfile = '')
  {
    global $dosql;
    if ($delfile) {
      removeFile($tbname, $id, $delfile);
    }
    // var_dump($tbname);
    $sql = "DELETE FROM `#@__$tbname` WHERE id=$id";

    if ($dosql->ExecNoneQuery($sql)) {
      $res = 1;
    } else {
      $res = 0;
    }
    returnAjax($res, $res ? "删除成功" : '删除失败');

  }
}

/**
 * @desc 根据字段删除对应路径文件
 * @param  $tbnane 表名
 * @param  $delfile 查找的字段 数组
 * @param  $id
 */
function removeFile($tbname, $id, $delfile = array())
{
  global $dosql;
  $info = getOne($tbname, ['id' => $id]);
  foreach ($delfile as $key => $val) {
    // 相同地址是否有其他数据使用
    $otherinfo = $dosql->GetOne("SELECT * FROM `#@__$tbname` WHERE id !=$id  and " . $val . "='" . $info[$val] . "'");

    // 删除组图图片文件
    if ($info[$val] && empty($otherinfo)) {
      // 包含存放的是图片组字符串，图组删除
      $arr = array_filter(explode(',', $info[$val]));
      foreach ($arr as $key => $value) {
        file_unlink(PHPOESOC_ROOT . '/' . $value);
      }
    }
  }

}
// 根据路径删除文件 删除成功返回true 反之false
function file_unlink($path)
{
  return is_file($path) && unlink($path);
}

if (!function_exists('allDelete')) {
  /**
   * [多个删除]
   * @param  [type] $tbname  [表名]
   * @param  [type] $delfile [需要删除的文件对应字段名]
   * @param  [type] $idarr   [id组]
   * @return [type]          [description]
   */
  function allDelete($tbname, $idarr, $delfile = '')
  {
    global $dosql;

    foreach ($idarr as $k => $vo) {

      $dosql->ExecNoneQuery("DELETE FROM `#@__$tbname` WHERE id=$vo");
      if ($delfile) {
        removeFile($tbname, $vo, $delfile);
      }
    }

    returnAjax(1, "删除成功");
    // 启动事务
    // Db::startTrans();
    // try {
    //     foreach ($idarr as $key => $vo) {
    //         // 删除文件
    //         if($delfile){
    //             removeFile($tbname,$vo,$delfile);
    //         }
    //         Db::name($tbname)->where('id=' . $vo)->delete();
    //     }
    //     // 提交事务
    //     Db::commit();
    //     returnAjax(1, "删除成功");
    // } catch (\Exception $e) {
    //     // 回滚事务
    //     Db::rollback();
    //     returnAjax(0, "删除失败",$e->getMessage());
    // }
  }
}

if (!function_exists('add_cdkey')) {
  /**
   * 批量添加卡密
   * @param string    $tbname 表名
   * @param number    $num 生成数量
   * @param array     $data 绑定数据信息
   * @return boolean
   */
  function add_cdkey($tbname, $num, $data = array())
  {
    global $dosql;
    // 卡密生成原
    $pattern = '1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLOMNOPQRSTUVWXYZ';
    // 启动事务
    for ($i = 0; $i < $num; $i++) {
      $data['cdkey'] = '';
      for ($b = 0; $b < 20; $b++) {
        $data['cdkey'] .= $pattern{mt_rand(0, 62)}; //生成php随机数
      }
      $info = $dosql->GetOne("SELECT * FROM `#@__$tbname` WHERE `cdkey`='" . $data['cdkey'] . "'");
      // 验证卡密是否存在

      if ($info) {
        $i = $i;
      } else {
        comPost($tbname, $data);
      }
    }

    return true;

  }
}

if (!function_exists('creat_number')) {
  /**
   * 生成唯一订单的编号
   * @param string    $tbname 表名
   * @param  string   $filed 编号存放字段
   * @param array     $data 绑定数据信息
   * @return str
   */
  function creat_number($tbname, $filed)
  {
    global $dosql;

    do {
      $out_trade_no = date("ymdHis").getmsectime().mt_rand(1000,9999);
      $info         = $dosql->GetOne("SELECT * FROM `#@__$tbname` WHERE `$filed`= '$out_trade_no' ");
    } while ($info);

    return $out_trade_no;
  }
}

if (!function_exists('getmsectime')) {
    function getmsectime()
    { 
      list($msec, $sec) = explode(' ', microtime());
      $res = (float)sprintf('%.0f', (floatval($msec)) * 1000);
      return $res;
    }
}


/**
 * [get 根据id获取一条]
 * @param  string $tbname [description]
 * @param  string $id     [description]
 * @return [type]         [description]
 */
function get($tbname = '', $id = '')
{
  global $dosql;

  if (!$tbname) {
    return '请输入表名';
  }

  if (empty($id)) {
    return 'id不存在';
  }

  $tbname = "#@__" . $tbname;
  $r      = $dosql->GetOne("SELECT * FROM `$tbname` WHERE id = '$id' ");
  if (isset($r) && is_array($r)) {
    return $r;
  } else {
    return false;
  }
}

/**
 * [getOne 获取一条数据]
 * @param  string $tbname [表名]
 * @param  array  $data   [查询条件数组]
 * @return [type]         [description]
 */
function getOne($tbname = '', $data = [])
{
  global $dosql;

  if (!$tbname) {
    return '请输入表名';
  }

  if (empty($data)) {
    return '查询数据为空';
  }

  $where = '';
  $i     = 0;
  foreach ($data as $key => $vo) {
    $i++;
    if ($i == 1) {
      $where .= " `$key` = '" . $vo . "'";
    } else {
      $where .= " AND `$key` = '" . $vo . "'";
    }
  }

  if (isset($data['id'])) {
    $r = get($tbname, $data['id']);
  } else {
    $tbname = "#@__" . $tbname;
    $r      = $dosql->GetOne("SELECT * FROM `$tbname` WHERE " . $where);
  }
  if (isset($r) && is_array($r)) {
    return $r;
  } else {
    return false;
  }
}

/**
 * [getCount 获取数量]
 * @param  string $tbname [description]
 * @param  string $where  [description]
 * @return [type]         [description]
 */
function getCount($tbname = '', $where = " 1=1")
{
  global $dosql;

  if (!$tbname) {
    return '请输入表名';
  }
  $count = $dosql->GetOne("SELECT COUNT(*) as count FROM `#@__$tbname`  WHERE " . $where)['count'];
  return $count;
}

/**
 * [getList 获取多条数据]
 * @param  [type] $tbname [description]
 * @param  [type] $where  [查询条件字符串]
 * @param  string $order  [description]
 * @param  string $sort   [description]
 * @param  string $limit  [description]
 * @return [type]         [description]
 */
function getList($tbname, $where = "1=1", $order = "orderid", $sort = "DESC", $limit = "")
{
  if (empty($order)) {
    $order = "orderid";
  }
  if (empty($sort)) {
    $sort = "DESC";
  }
  global $dosql;
  $list      = array();
  $new_where = '';
  if (is_array($where)) {
    $i = 0;
    foreach ($where as $key => $vo) {
      $i++;
      if ($i == 1) {
        $new_where .= " `$key` = '" . $vo . "'";
      } else {
        $new_where .= " AND `$key` = '" . $vo . "'";
      }
    }
    $where = $new_where;
  }

  if (!empty($limit)) {
    $limit = ' limit ' . $limit;
  }
  $dosql->Execute("SELECT * FROM `#@__$tbname` WHERE " . $where . " ORDER BY " . $order . ' ' . $sort . $limit);

  if (!$dosql) {

    return false;
  } else {
    while ($row = $dosql->GetArray()) {
      array_push($list, $row);
    }
    $data = array(
      'count' => getCount($tbname, $where),
      'list'  => $list,
    );
    return $data;

  }
}

//框架MD5加密
/**
 * [mmd5 我的加密]
 * @param  [type] $str [description]
 * @return [type]      [description]
 */
function mmd5($str)
{
  return md5(md5($str . 'oesoc_x_x_oeosc'));
}

/**
 * 随机图片
 * */
if (!function_exists('background')) {
  function background()
  {
    $file_path = PHPOESOC_ROOT;
    $file_dirs = '/admin/templates/images/bg/';
    if (!is_dir($back_path = $file_path . $file_dirs)) {
      return null;
    }
    $dir_menu = opendir($back_path);
    var_dump($dir_menu);
 
    while ($content = readdir($dir_menu)) {
      {
        if ($content != '.' && $content != '..') {
          {
            $arr[] = $content;
          }
        }
        return str_replace('\\', '/', $file_dirs . $arr[rand(0, count($arr) - 1)]);
      }

    }
  }

}

/**
 * 加密函数
 * @param   string  $text
 * @param   string  $key
 * @return  string
 */
if ( !function_exists ('lock_url')){
    function lock_url ($txt, $key = 'wheakerd'){
        $chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-=+";
        $nh    = rand (0,64);
        $ch    = $chars [$nh];
        $mdKey = md5 ($key . $ch);
        $mdKey = substr ($mdKey, $nh % 8, $nh % 8 + 7);
        $txt   = base64_encode ($txt);
        $tmp   = '';
        $i = 0; $j = 0; $k = 0;
        for ($i = 0; $i < strlen ($txt); $i ++)
        {
            $k = $k == strlen ($mdKey) ? 0 : $k;
            $j = ($nh + strpos ($chars, $txt [$i]) + ord ($mdKey [$k ++])) % 64;
            $tmp .= $chars [$j];
        }
        return urlencode ($ch . $tmp);
    }
}
/**
 * 解密函数
 * @param   string  $txt
 * @param   string  $key
 * @return  string
 */
if (!function_exists ('unlock_url')){
    function unlock_url ($txt, $key = 'wheakerd'){
        $txt   = urldecode ($txt);
        $chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-=+";
        $ch    = $txt [0];
        $nh    = strpos ($chars, $ch);
        $mdKey = md5 ($key . $ch);
        $mdKey = substr ($mdKey, $nh % 8, $nh % 8 + 7);
        $txt   = substr ($txt, 1);
        $tmp   = '';
        $i = 0; $j = 0; $k = 0;
        for ($i = 0; $i < strlen ($txt); $i ++)
        {
            $k = $k == strlen ($mdKey) ? 0 : $k;
            $j = strpos ($chars, $txt [$i]) - $nh - ord ($mdKey [$k ++]);
            while ($j < 0) $j += 64;
            $tmp .= $chars [$j];
        }
        return base64_decode ($tmp);
    }
}

// 判断是否是微信环境
function is_weixin(){
    if (strpos($_SERVER['HTTP_USER_AGENT'], 'MicroMessenger') !== false) {
        return true;
    } else {
        return false;
    }
}

/**
 * [get_region_name 获取地址信息]
 * @param  [type] $code [description]
 * @return [type]       [description]
 */
function getRegionName($code,$res=''){
    global $dosql;
    
    $data = getOne('region',['code'=>$code]);
    if($code == '100000'){
        return ;
    }
    if($data){
        $res = $data['full_name'].','.getRegionName($data['parent_code']);
        return $res; 
    }


}
