<?php 
  require_once(dirname(__FILE__).'/inc/config.inc.php');

  $tbname = empty($tbname)?'':$tbname;
  if(empty($tbname)){
    echo '请传入tbname的值，(值是上传数据的表格名称)';
    exit;
  }
  switch($tbname)
  {
    
    case 'infolist':
      $type = 1;
      break;
    case 'infoimg':
      $type = 2;
      break;
    default:
    echo '该表不支持或不存在';
    exit;
  }
?>
<!DOCTYPE html>
<html>

<head>
  <meta charset="utf-8">
  <title>批量</title>
  <meta name="renderer" content="webkit">
  <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=0">
  <link href="../static/layui/css/layui.css" rel="stylesheet" type="text/css"/>
  <script src="../static/layui/layui.js" type="text/javascript"></script>
  <style type="text/css">
  /*组图上传效果*/
  .layui-upload-img {
    width: 92px;
    height: 92px;
    margin: 0 10px 10px 0;
  }

  .layui-upload-img {
    width: 90px;
    height: 90px;
    margin: 0;
  }

  .pic-more {
    width: 100%;
    left;
    margin: 10px 0px 0px 0px;
  }

  .pic-more li {
    width: 90px;
    float: left;
    margin-right: 5px;
  }

  .pic-more li .layui-input {
    display: initial;
  }

  .pic-more li a {
    position: absolute;
    top: 0;
    display: block;
  }

  .pic-more li a i {
    font-size: 24px;
    background-color: #008800;
  }

  #slide-pc-priview .item_img img {
    width: 90px;
    height: 90px;
  }

  #slide-pc-priview li {
    position: relative;
  }

  #slide-pc-priview li .operate {
    color: #000;
    display: none;
  }

  #slide-pc-priview li .toleft {
    position: absolute;
    top: 40px;
    left: 1px;
    cursor: pointer;
  }

  #slide-pc-priview li .toright {
    position: absolute;
    top: 40px;
    right: 1px;
    cursor: pointer;
  }

  #slide-pc-priview li .close {
    position: absolute;
    top: 5px;
    right: 5px;
    cursor: pointer;
  }

  #slide-pc-priview li:hover .operate {
    display: block;
  }
  </style>
</head>

<body>
  <div class="layui-fluid">
    <div class="layui-row layui-col-space15">
      <div class="layui-col-md12">
        <div class="layui-card">
          <div class="layui-card-header">批量添加视频添加(小视频不能太大)</div>
          <div class="layui-card-body" pad15>
            <div class="layui-form" lay-filter="">
              <!-- 价格输入框 -->
              <div class="layui-upload">
                <div class="layui-btn-container">
                  <button type="button" class="layui-btn layui-btn-normal" id="testList">选择多文件</button>
                  <button type="button" class="layui-btn layui-btn-danger " id="testListAction">开始上传</button>
                </div>
                <div class="layui-form-item">
                  <div class="layui-input-inline">
                    <select name="classid" id="classid" lay-filter="classid" required="" lay-verify ="required">
                      <option value="">请选择所属栏目</option>
                      <?php CategoryTypeMy($type); ?>
                    </select>
                  </div>
                  <div class="layui-input-inline">
                    <input type="hidden" name="tbname" required  lay-verify="required" placeholder="表名" autocomplete="off" class="layui-input" value="<?php echo $tbname ?>">
                  </div>
                </div>
                <div class="layui-upload-list" >
                  <table class="layui-table">
                    <colgroup>
                      <col width="100">
                      <col width="80">
                      <col width="110">
                      <col >
                      <col width="150">
                    </colgroup>
                    <thead>
                      <tr>
                        <th>文件名</th>
                        <th>大小</th>
                        <th>上传进度</th>
                        <th>文件路径</th>
                        <th>操作</th>
                      </tr>
                    </thead>
                    <tbody id="demoList"></tbody>
                  </table>
                </div>

              </div>
              <div class="layui-form-item">
                <div class="layui-input-block">
                  <button class="layui-btn" lay-submit lay-filter="post"><i class="layui-icon layui-icon-ok"></i>确认提交</button>
                  <!-- <button class="layui-btn" onclick="window.history.go(-1);"><i class="layui-icon layui-icon-return"></i>返回</button> -->
                  <!--  <button type="reset" class="layui-btn layui-btn-primary">重新填写</button> -->
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

    </div>
  </div>
  <script src="//unpkg.com/layui@2.6.8/dist/layui.js"></script>
  <!-- <script src="__STATIC__/layuiadmin/layui/layui.all.js"></script> -->
  <script>
  var ajax = 0;

  layui.use(function(){
    var layer = layui.layer ,form = layui.form,$ = layui.$,upload = layui.upload,element = layui.element,laypage = layui.laypage,util = layui.util;
  
    

      //演示多文件列表
    var uploadListIns = upload.render({
      elem: '#testList',
      elemList: $('#demoList'),//列表元素对象
      url: 'aall_upload.php?type=image',
      accept: 'images',
      multiple: true,
      number: 50,
      auto: false,
      bindAction: '#testListAction',
      choose: function(obj) {
        var that = this;
        var files = this.files = obj.pushFile(); //将每次选择的文件追加到文件队列
        //读取本地文件
        obj.preview(function(index, file, result) {
          var tr = $(
            [
            '<tr id="upload-' + index + '">', 
            '<td>' + file.name + '</td>', 
            '<td>' + (file.size / 1014).toFixed(1) + 'kb</td>', 
            '<td><div class="layui-progress" lay-filter="progress-demo-' + index + '"><div class="layui-progress-bar" lay-percent=""></div></div></td>', 
            `<td > 
              <table lay-skin="nob ">
                <tr>
                  <td>
                      <img src="" style="width:80px;height: 80px;">
                  </td>
                  <td>
                    <div class="layui-input-inline">
                      <input  type="text" name="title[]"  lay-verify="required" placeholder="文章标题" autocomplete="off" class="layui-input" value="` + file.name + `">
                    </div> 
                  </td>
                  <td>
                    <div class="layui-input-inline">
                      <input  type="text" name="files[]" lay-verify="required" placeholder="文件路径" autocomplete="off" class="layui-input files_url">
                    </div> 
                  </td>
                  <td>
                    <button class="layui-btn layui-btn-primary layui-btn-sm" data-url="" data-type="videopreview">预览</button>
                  </td>
                </tr>
              </table>
              
              
              </td>`, 
            `<td>
              <button class="layui-btn layui-btn-xs demo-reload layui-hide">重传</button>
              <button class="layui-btn layui-btn-xs layui-btn-danger demo-delete">删除</button>
            </td>`, 
            '</tr>'
            ].join(''));

          //单个重传
          tr.find('.demo-reload').on('click', function() {
            obj.upload(index, file);
          });

          //删除
          tr.find('.demo-delete').on('click', function() {
            delete files[index]; //删除对应的文件
            tr.remove();
            uploadListIns.config.elem.next()[0].value = ''; //清空 input file 值，以免删除后出现同名文件不可选
          });

          that.elemList.append(tr);
          element.render('progress'); //渲染新加的进度条组件
        });
      },
      done: function(res, index, upload) { //成功的回调
        // console.log(res);
        var that = this;
        //if(res.code == 0){ //上传成功
        var tr = that.elemList.find('tr#upload-' + index),
          tds = tr.children();
          tds.eq(3).find('img').attr('src', res.pic_url);
          tds.eq(3).find('.files_url').val(res.pic_url.replace('../',''));
          tds.eq(3).find('.layui-btn').attr('data-url',res.pic_url);
          tds.eq(4).html(''); //清空操作
        delete this.files[index]; //删除文件队列已经上传成功的文件
        return;
        //}
        this.error(index, upload);
      },
      allDone: function(obj) { //多文件上传完毕后的状态回调
        console.log(obj)
      },
      error: function(index, upload) { //错误回调
        var that = this;
        var tr = that.elemList.find('tr#upload-' + index),
          tds = tr.children();
        tds.eq(3).find('.demo-reload').removeClass('layui-hide'); //显示重传
      },
      progress: function(n, elem, e, index) { //注意：index 参数为 layui 2.6.6 新增
        element.progress('progress-demo-' + index, n + '%'); //执行进度条。n 即为返回的进度百分比
      }
    });

    //提交
    form.on('submit(post)', function(data) {
      if (ajax == 1) { return false; }
      layer.load(1, { shade: [0.7, '#fff'] });
      ajax = 1;

      $.ajax({
        url: 'ajax_do.php?action=piliang_add', //请求的url地址
        dataType: "json", //返回的格式为json
        async: true, //请求是否异步，默认true异步，这是ajax的特性
        data: data.field, //参数值
        type: "POST", //请求的方式
        success: function(req) {
         layer.closeAll()
          if (req.status != 1) {
            ajax = 0;
          } else {
            setTimeout(function() {
              // top.layui.index.openTabsPage(req.redirect,'会员列表');
              window.location.href="";
              // window.location.href=req.redirect;
            }, 1000)
          }
          layer.msg(req.message);
        }
      });
      return false;
    });

    // 按钮data-type绑定事件
    active = {
      // 按钮data-type绑定事件
      // 视频预览
      videopreview: function($this) {
        
        var videourl = $(this).attr('data-url');
        
        if (videourl == '') {
          layer.msg('暂无预览信息');
          return false;
        }
        layer.open({
          type: 2,
          title: false,
          area: ['630px', '360px'],
          shade: 0.8,
          closeBtn: 0,
          shadeClose: true,
          content: videourl
        });
      }
    };

    //按钮 根据data-type绑定事件
    $(document).on('click', '.layui-btn', function(e) {
      var type = $(this).data('type');
      active[type] ? active[type].call(this) : '';
    });

   
  });
  </script>
</body>

</html>